****************************************************************************
***
*** SAMPLE1.PRG - ODBC API Declares sample
***
***        Pablo Almunia Sanz
***        100341.1136@compuserve.com
***
*** Version - 1.0 - first release
***
****************************************************************************

*** Charge all declares and defines for ODBC API
#include "odbcapi.h"
DO odbcapi

*** Connection with SPT Command of VPF
*** (change this datasource)
nConnection = SQLCONNECT( "CBK" )

*** The internal ODBC connection handle
nHdbc = SQLGETPROP( nConnection, "ODBCHdbc"  )

*** Create a ODBC statement handle
nHstmt = 0
nResult = SQLAllocStmt( nHdbc, @nHstmt )

IF nResult == SQL_SUCCESS

  *** Execute a SQL Command
  *** (change this sentence)
  nResult = SQLExecDirect( nHstmt, "SELECT * FROM LIBROS", SQL_NTS )

  IF nResult == SQL_SUCCESS OR nResult == SQL_SUCCESS_WITH_INFO

    *** Number of columns in the result
    nNumCols = 0
    nResult = SqlNumResultCols( nHstmt, @nNumCols )

    IF nResult == SQL_SUCCESS

      *** Create a string with a CREATE CURSOR command
      *** (change this cursor name)
      cEject = 'CREATE CURSOR sqlresult ('

      *** Information about all columns
      FOR nColCount = 1 TO nNumCols

        cColName = REPLICATE( CHR(0), 256 )
        nColDef = 0
        nSqlType = 0
        nColDef = 0
        nScale = 0
        nNullable = 0

        *** Returns the result descriptor
        =SQLDescribeCol( nHstmt, nColCount, @cColName, LEN( cColName ), ;
                         @nColDef, @nSqlType, @nColDef, @nScale, @nNullable )

        *** Name of column
        cEject = cEject + SUBSTR( cColName, 1, AT( CHR(0), cColName ) - 1 ) + ' '

        *** Datatype of column
        DO CASE
        CASE INLIST( nSqlType, SQL_CHAR, SQL_VARCHAR, SQL_LONGVARCHAR )
          IF nColDef > 255
            cEject = cEject + 'M'
          ELSE
            cEject = cEject + 'C(' + LTRIM(STR( nColDef )) + ')'
          ENDIF
        CASE INLIST( nSqlType, SQL_BINARY, SQL_VARBINARY, SQL_LONGVARBINARY  )
          cEject = cEject + 'M'
        CASE INLIST( nSqlType, SQL_DECIMAL, SQL_NUMERIC  )
          cEject = cEject + 'N(' + LTRIM(STR( nColDef )) + ',' + LTRIM(STR( nScale )) + ')'
        CASE nSqlType = SQL_BIT
          cEject = cEject + 'L'
        CASE INLIST( nSqlType, SQL_TINYINT, SQL_SMALLINT, SQL_INTEGER )
          cEject = cEject + 'I'
        CASE nSqlType = SQL_BIGINT
          cEject = cEject + 'C(' + LTRIM(STR( nColDef )) + ')'
        CASE INLIST( nSqlType, SQL_REAL, SQL_FLOAT, SQL_DOUBLE )
          cEject = cEject + 'B(' + LTRIM(STR( nScale )) + ')'
        CASE nSqlType = SQL_DATE
          cEject = cEject + 'D'
        CASE INLIST( nSqlType, SQL_TIME, SQL_TIMESTAMP )
          cEject = cEject + 'T'
        ENDCASE

        *** Make the command
        IF nColCount != nNumCols
          cEject = cEject +', '
        ENDIF
      NEXT

      *** Close the CREATE CURSOR Command
      cEject = cEject + ')'

      *** Macro substitution
      &cEject

      *** Obtain all Row
      *** (you can get some Row)

      nCountRow = 0

      DO WHILE SQLFetch( nHstmt ) = SQL_SUCCESS

                *** Limits of rows
                *** (Change for you)
        nCountRow = nCountRow + 1
                IF nCountRow > 100
                        EXIT
                ENDIF

        *** Show a message
        *WAIT WINDOW "Fetch " + LTRIM( STR( nCountRow ) ) + " Rows" NOWAIT

        *** New Row in the cursor
        APPEND BLANK

        *** Obtain all Columns
        FOR nColCount = 1 TO nNumCols

          *** Get a Data
          cBuffer = REPLICATE( CHR(0), 256 )
          nResult = SQLGetData( nHstmt, nColCount, 1, @cBuffer, 256, 15)

          *** Datatype convert and store in the cursor
          cField = FIELD( nColCount )
          DO CASE
          CASE INLIST( TYPE( cField ), 'C', 'M' )
            REPLACE (cField) WITH SUBSTR( cBuffer, 1, AT( CHR(0), cBuffer ) -1 )
          CASE INLIST( TYPE( cField ), 'N', 'I', 'B' )
            REPLACE (cField) WITH VAL( SUBSTR( cBuffer, 1, AT( CHR(0), cBuffer ) -1 ) )
          CASE INLIST( TYPE( cField ), 'D' )
            REPLACE (cField) WITH CTOD( SUBSTR( cBuffer, 1, AT( CHR(0), cBuffer ) -1 ) )
          CASE INLIST( TYPE( cField ), 'T' )
            REPLACE (cField) WITH CTOT( SUBSTR( cBuffer, 1, AT( CHR(0), cBuffer ) -1 ) )
          ENDCASE
        NEXT
      ENDDO  && End of SQLFetch

    ELSE

      *** Error in SqlNumResultCols
      =ODBCErrorr( VAL( SYS(3053) ), nHdbc, nHstmt )
      =SQLFreeStmt( nHstmt, SQL_CLOSE )
      =SQLDISCONN( nConnecion )
      RETURN .F.

    ENDIF

  ELSE

    *** Error in SQLExecDirect
    =ODBCError( VAL( SYS(3053) ), nHdbc, nHstmt )
    =SQLFreeStmt( nHstmt, SQL_CLOSE )
    =SQLDISCONN( nConnection )
    RETURN .F.

  ENDIF

ELSE

  **** Error in SQLAllocStmt
  =ODBCError( VAL( SYS(3053) ), nHdbc, SQL_NULL_HSTMT )
  =SQLDISCONN( nConnection )
  RETURN .F.

ENDIF

*** Destroy the ODBC statement handle
=SQLFreeStmt( nHstmt, SQL_CLOSE )  && See odbcapi.PRG

*** Close the connection with SPT of VFP
=SQLDISCONN( nConnection )

RETURN .T.
*** End of sample


*** Error Handling Procedure for ODBC API Error
PROCEDURE ODBCError
LPARAMETER nHenv, nHdbc, nHstmt

*** Initialitation
cSqlState = REPLICATE( CHR(0), 255 )
nNativeError = 0
cErrorMsg = REPLICATE( CHR(0), 255 )
nErrorMsgSize = 0

*** Function for error information
IF SQLError( nHenv, nHdbc, nHstmt, @cSqlState, @nNativeError, @cErrorMsg, LEN( cErrorMsg ), @nErrorMsgSize ) == SQL_SUCCESS
  *** Build the error Message
  cMessageError =                 'State : ' + SUBSTR( cSqlState, 1, AT( CHR(0), cSqlState ) -1 ) + CHR(13)
  cMessageError = cMessageError + 'Native Error : ' + STR( nNativeError ) + CHR(13)
  cMessageError = cMessageError + 'Error : ' + SUBSTR( cErrorMsg, 1, nErrorMsgSize - 1 ) + CHR(13)
ELSE
  cMessageError = 'Error : <empty>'
ENDIF

*** Show the Message
=MESSAGEBOX( cMessageError, 64, 'ODBC API Error' )

RETURN .T.
*** End of ODBCError